# Cockroach

After the *0.3.0* version of the package, the team focused on developing for Cockroach several self-help modules for python developers. In addition to producing highlighted logs and naming them, which was even the initial aim of the package, to improve the way we program.

Until version *0.4.1* of the package, the package only provides the log() of the developing_cockroach.py module.
For the versions we use the following versioning nameclature.

1.2.3
1 -> Function of great importance incorporated.
2 -> Improvement.
3 -> Bug fixes.

The team decided to release the release naming as we felt it would be of great importance to the users of the package.

Até a verão *0.4.1* do pacote, o pacote apenas fornece o log() do modulo developing_cockroach.py.
Para as versão usamos a seguite nomeclatura de versionamento.

1.2.3
1 -> Function of great importance incorporated.
2 -> Improvement.
3 -> Bug fixes.

The team decided to release the release naming as we felt it would be of great importance to the users of the package.

*Note: This documentation is only valid for versions from 0.3.0*

## 🚀 Starting
* [Official documentation in Portuguese](https://github.com/farioso-fernando/developer/blob/main/doc/readme-pt.md)

These instructions will allow you to get a copy of the project running on your local machine for development and testing purposes.

See **Deployment** to learn how to deploy the project.

### 📋 Prerequisites

What things do you need to install the software and how do I install it?

```
Any version of Python3 above and have the pip installed on your machine.
```

You won't need a lot of things to run the project. Just having a version of python3 on your machine is enough. If there are more requirements needed for execution, we will document.

### 🔧 Installation

Step-by-step examples so you have a running development environment.

See the examples below:

Open your terminal emulator run the following command:

```
pip install Developing-Cockroach
```

or use pip3 and specify the version

```
pip3 install Developing-Cockroach == 0.3.0
```

That way you'll have the full software on your machine.


## 📦 Development

In a python file:

```
from cockroach import developing_cockroach as developer
developer.log(message= "This is a log message.")

Exit:
[Log]: This is a log message.
```

### 🔩 End-to-end analysis

The *cockroach* line is the main module of our package and it is from there that the modules originate.
*developing_cockroach* is the main module with issues that have to do with custom log generation.
```
developing_cockroach.log('I, Cockroach!')
```

## 🛠️ Built with

The tools used to create the project

* [Visual Studio Code](https://code.visualstudio.com/) - Visual Studio Code is a source code editor developed by Microsoft for Windows, Linux and macOS.
* [pip](https://pypi.org/project/pip/) - Dependency Manager
* [Git](https://git-scm.com/) - Distributed version control system.

## 🖇️ Collaborating

Please read [COLLABORATION.md](https://github.com/farioso-fernando/developer/blob/main/COLLABORATION.md) for details on our code of conduct and the process for submitting requests for request.

## 📌 Version

We use [Git] and [GitHub](https://git-scm.com/)(https://github.com/) for version control. For available versions, note the [tags in this repository](#).

## ✒️ Authors

Those who helped raise the project since its inception

* **Farioso Fernando** - *Initial Work* - [adeveloper](https://github.com/farioso-fernando)
* **Farioso Fernando** - *Documentation* - [so-and-so](https://github.com/farioso-fernando)

You can also see the list of all [contributors](https://github.com/farioso-fernando/developer/contributors.md) who participated in this project.

## 📄 License

This project is under MIT License - see the [LICENSE.md](https://github.com/farioso-fernando/developer/blob/main/LICENSE) file for details.

## 🎁 Expressions of gratitude

* Tell others about this project 📢
* Invite someone from the team for a beer 🍺
*Thank you publicly 🤓.
* etc.

---

⌨️ with ❤️ by [Farioso Fernando](https://gist.github.com/farioso-fernando) 😊